/*
 * Decompiled with CFR 0.152.
 */
package com.sun.j3d.utils.behaviors.sensor;

import com.sun.j3d.utils.behaviors.sensor.SensorButtonListener;
import com.sun.j3d.utils.behaviors.sensor.SensorEvent;
import com.sun.j3d.utils.behaviors.sensor.SensorReadListener;
import com.sun.j3d.utils.timer.J3DTimer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.media.j3d.Sensor;
import javax.media.j3d.Transform3D;

public class SensorEventAgent {
    private long t0 = 0L;
    private Object source = null;
    private SensorEvent e = new SensorEvent();
    private List bindingsList = new ArrayList();
    private SensorBinding[] bindings = new SensorBinding[0];
    private boolean listsDirty = false;

    public SensorEventAgent(Object object) {
        this.source = object;
    }

    private SensorBinding getSensorBinding(Sensor sensor) {
        for (int i2 = 0; i2 < this.bindingsList.size(); ++i2) {
            SensorBinding sensorBinding = (SensorBinding)this.bindingsList.get(i2);
            if (sensorBinding.sensor != sensor) continue;
            return sensorBinding;
        }
        return null;
    }

    public synchronized void addSensorButtonListener(Sensor sensor, int n2, SensorButtonListener sensorButtonListener) {
        if (sensor == null) {
            throw new NullPointerException("\nsensor is null");
        }
        if (n2 >= sensor.getSensorButtonCount()) {
            throw new ArrayIndexOutOfBoundsException("\nbutton " + n2 + " >= sensor button count " + sensor.getSensorButtonCount());
        }
        SensorBinding sensorBinding = this.getSensorBinding(sensor);
        if (sensorBinding == null) {
            sensorBinding = new SensorBinding(sensor);
            this.bindingsList.add(sensorBinding);
        }
        SensorButtonListener[] sensorButtonListenerArray = new SensorButtonListener[sensorBinding.buttons.length];
        sensorButtonListenerArray[n2] = sensorButtonListener;
        SensorButtonBinding sensorButtonBinding = new SensorButtonBinding(sensorButtonListenerArray, true);
        sensorBinding.buttonBindingsList.add(sensorButtonBinding);
        this.listsDirty = true;
    }

    public synchronized void addSensorButtonListener(Sensor sensor, SensorButtonListener sensorButtonListener) {
        if (sensor == null) {
            throw new NullPointerException("\nsensor is null");
        }
        SensorBinding sensorBinding = this.getSensorBinding(sensor);
        if (sensorBinding == null) {
            sensorBinding = new SensorBinding(sensor);
            this.bindingsList.add(sensorBinding);
        }
        SensorButtonListener[] sensorButtonListenerArray = new SensorButtonListener[sensorBinding.buttons.length];
        for (int i2 = 0; i2 < sensorBinding.buttons.length; ++i2) {
            sensorButtonListenerArray[i2] = sensorButtonListener;
        }
        SensorButtonBinding sensorButtonBinding = new SensorButtonBinding(sensorButtonListenerArray, true);
        sensorBinding.buttonBindingsList.add(sensorButtonBinding);
        this.listsDirty = true;
    }

    public synchronized void addSensorButtonListeners(Sensor sensor, SensorButtonListener[] sensorButtonListenerArray) {
        if (sensor == null) {
            throw new NullPointerException("\nsensor is null");
        }
        SensorBinding sensorBinding = this.getSensorBinding(sensor);
        if (sensorBinding == null) {
            sensorBinding = new SensorBinding(sensor);
            this.bindingsList.add(sensorBinding);
        }
        if (sensorBinding.buttons.length != sensorButtonListenerArray.length) {
            throw new IllegalArgumentException("\nbuttonListeners length " + sensorButtonListenerArray.length + " must equal sensor button count " + sensorBinding.buttons.length);
        }
        SensorButtonBinding sensorButtonBinding = new SensorButtonBinding(sensorButtonListenerArray, false);
        sensorBinding.buttonBindingsList.add(sensorButtonBinding);
        this.listsDirty = true;
    }

    public SensorButtonListener[] getSensorButtonListeners(Sensor sensor, int n2) {
        if (sensor == null) {
            throw new NullPointerException("\nsensor is null");
        }
        if (n2 >= sensor.getSensorButtonCount()) {
            throw new ArrayIndexOutOfBoundsException("\nbutton " + n2 + " >= sensor button count " + sensor.getSensorButtonCount());
        }
        SensorBinding sensorBinding = this.getSensorBinding(sensor);
        if (sensorBinding == null) {
            return null;
        }
        ArrayList<SensorButtonListener> arrayList = new ArrayList<SensorButtonListener>();
        for (int i2 = 0; i2 < sensorBinding.buttonBindingsList.size(); ++i2) {
            SensorButtonBinding sensorButtonBinding = (SensorButtonBinding)sensorBinding.buttonBindingsList.get(i2);
            if (sensorButtonBinding.listeners[n2] == null) continue;
            arrayList.add(sensorButtonBinding.listeners[n2]);
        }
        if (arrayList.size() == 0) {
            return null;
        }
        return arrayList.toArray(new SensorButtonListener[arrayList.size()]);
    }

    private void removeSensorButtonListener(SensorBinding sensorBinding, SensorButtonListener sensorButtonListener) {
        Iterator iterator = sensorBinding.buttonBindingsList.iterator();
        while (iterator.hasNext()) {
            int n2 = 0;
            SensorButtonBinding sensorButtonBinding = (SensorButtonBinding)iterator.next();
            for (int i2 = 0; i2 < sensorButtonBinding.listeners.length; ++i2) {
                if (sensorButtonBinding.listeners[i2] == sensorButtonListener) {
                    sensorButtonBinding.listeners[i2] = null;
                    continue;
                }
                if (sensorButtonBinding.listeners[i2] == null) continue;
                ++n2;
            }
            if (n2 != 0) continue;
            iterator.remove();
        }
        this.listsDirty = true;
    }

    public synchronized void removeSensorButtonListener(Sensor sensor, SensorButtonListener sensorButtonListener) {
        if (sensor == null) {
            throw new NullPointerException("\nsensor is null");
        }
        SensorBinding sensorBinding = this.getSensorBinding(sensor);
        if (sensorBinding == null) {
            return;
        }
        this.removeSensorButtonListener(sensorBinding, sensorButtonListener);
        if (sensorBinding.buttonBindingsList.size() == 0 && sensorBinding.readBindingsList.size() == 0) {
            this.removeSensorBinding(sensor);
        }
        this.listsDirty = true;
    }

    public synchronized void removeSensorButtonListener(SensorButtonListener sensorButtonListener) {
        Iterator iterator = this.bindingsList.iterator();
        while (iterator.hasNext()) {
            SensorBinding sensorBinding = (SensorBinding)iterator.next();
            this.removeSensorButtonListener(sensorBinding, sensorButtonListener);
            if (sensorBinding.buttonBindingsList.size() != 0 || sensorBinding.readBindingsList.size() != 0) continue;
            iterator.remove();
        }
        this.listsDirty = true;
    }

    public synchronized void addSensorReadListener(Sensor sensor, SensorReadListener sensorReadListener) {
        if (sensor == null) {
            throw new NullPointerException("\nsensor is null");
        }
        SensorBinding sensorBinding = this.getSensorBinding(sensor);
        if (sensorBinding == null) {
            sensorBinding = new SensorBinding(sensor);
            this.bindingsList.add(sensorBinding);
        }
        sensorBinding.readBindingsList.add(sensorReadListener);
        this.listsDirty = true;
    }

    public SensorReadListener[] getSensorReadListeners(Sensor sensor) {
        if (sensor == null) {
            throw new NullPointerException("\nsensor is null");
        }
        SensorBinding sensorBinding = this.getSensorBinding(sensor);
        if (sensorBinding == null) {
            return null;
        }
        if (sensorBinding.readBindingsList.size() == 0) {
            return null;
        }
        return sensorBinding.readBindingsList.toArray(new SensorReadListener[sensorBinding.readBindingsList.size()]);
    }

    private void removeSensorReadListener(SensorBinding sensorBinding, SensorReadListener sensorReadListener) {
        Iterator iterator = sensorBinding.readBindingsList.iterator();
        while (iterator.hasNext()) {
            if ((SensorReadListener)iterator.next() != sensorReadListener) continue;
            iterator.remove();
        }
        this.listsDirty = true;
    }

    public synchronized void removeSensorReadListener(Sensor sensor, SensorReadListener sensorReadListener) {
        if (sensor == null) {
            throw new NullPointerException("\nsensor is null");
        }
        SensorBinding sensorBinding = this.getSensorBinding(sensor);
        if (sensorBinding == null) {
            return;
        }
        this.removeSensorReadListener(sensorBinding, sensorReadListener);
        if (sensorBinding.buttonBindingsList.size() == 0 && sensorBinding.readBindingsList.size() == 0) {
            this.removeSensorBinding(sensor);
        }
        this.listsDirty = true;
    }

    public synchronized void removeSensorReadListener(SensorReadListener sensorReadListener) {
        Iterator iterator = this.bindingsList.iterator();
        while (iterator.hasNext()) {
            SensorBinding sensorBinding = (SensorBinding)iterator.next();
            this.removeSensorReadListener(sensorBinding, sensorReadListener);
            if (sensorBinding.buttonBindingsList.size() != 0 || sensorBinding.readBindingsList.size() != 0) continue;
            iterator.remove();
        }
        this.listsDirty = true;
    }

    public synchronized void removeSensorBinding(Sensor sensor) {
        Iterator iterator = this.bindingsList.iterator();
        while (iterator.hasNext()) {
            SensorBinding sensorBinding = (SensorBinding)iterator.next();
            if (sensorBinding.sensor != sensor) continue;
            iterator.remove();
            break;
        }
        this.listsDirty = true;
    }

    public Sensor[] getSensors() {
        if (this.bindingsList.size() == 0) {
            return null;
        }
        Sensor[] sensorArray = new Sensor[this.bindingsList.size()];
        for (int i2 = 0; i2 < this.bindingsList.size(); ++i2) {
            sensorArray[i2] = ((SensorBinding)this.bindingsList.get((int)i2)).sensor;
        }
        return sensorArray;
    }

    private synchronized void updateArrays() {
        this.bindings = this.bindingsList.toArray(new SensorBinding[this.bindingsList.size()]);
        for (int i2 = 0; i2 < this.bindings.length; ++i2) {
            this.bindings[i2].updateArrays();
        }
    }

    public void dispatchEvents() {
        long l2 = this.t0;
        this.t0 = J3DTimer.getValue();
        if (this.listsDirty) {
            this.updateArrays();
            this.listsDirty = false;
        }
        for (int i2 = 0; i2 < this.bindings.length; ++i2) {
            int n2;
            SensorBinding sensorBinding = this.bindings[i2];
            Sensor sensor = sensorBinding.sensor;
            Transform3D transform3D = sensorBinding.read;
            int[] nArray = sensorBinding.buttons;
            int n3 = 0;
            boolean bl = true;
            boolean bl2 = false;
            sensor.getRead(transform3D);
            sensor.lastButtons(nArray);
            for (n2 = 0; n2 < sensorBinding.buttonBindings.length; ++n2) {
                SensorButtonBinding sensorButtonBinding = sensorBinding.buttonBindings[n2];
                for (int i3 = 0; i3 < nArray.length; ++i3) {
                    if (sensorButtonBinding.listeners[i3] == null) continue;
                    if (sensorButtonBinding.prevButtons[i3]) {
                        if (nArray[i3] == 0) {
                            this.e.set(this.source, 2, sensor, transform3D, nArray, i3, this.t0, l2);
                            sensorButtonBinding.listeners[i3].released(this.e);
                            sensorButtonBinding.prevButtons[i3] = false;
                            --sensorButtonBinding.buttonsHandled;
                        } else {
                            bl2 = true;
                            n3 = i3;
                        }
                        bl = false;
                        continue;
                    }
                    if (nArray[i3] != 1 || sensorButtonBinding.buttonsHandled != 0 && !sensorButtonBinding.multiButton) continue;
                    this.e.set(this.source, 1, sensor, transform3D, nArray, i3, this.t0, l2);
                    sensorButtonBinding.listeners[i3].pressed(this.e);
                    sensorButtonBinding.prevButtons[i3] = true;
                    ++sensorButtonBinding.buttonsHandled;
                    bl = false;
                }
                if (!bl2) continue;
                this.e.set(this.source, 3, sensor, transform3D, nArray, -1, this.t0, l2);
                sensorButtonBinding.listeners[n3].dragged(this.e);
            }
            if (!bl) continue;
            this.e.set(this.source, 4, sensor, transform3D, nArray, -1, this.t0, l2);
            for (n2 = 0; n2 < sensorBinding.readBindings.length; ++n2) {
                sensorBinding.readBindings[n2].read(this.e);
            }
        }
    }

    public String toString() {
        String string = "SensorEventAgent@" + Integer.toHexString(this.hashCode());
        string = string + "\nsensor bindings:\n\n";
        for (int i2 = 0; i2 < this.bindingsList.size(); ++i2) {
            string = string + ((SensorBinding)this.bindingsList.get(i2)).toString() + "\n";
        }
        return string;
    }

    private static class SensorBinding {
        Sensor sensor = null;
        int[] buttons = null;
        Transform3D read = null;
        List buttonBindingsList = new ArrayList();
        SensorButtonBinding[] buttonBindings = new SensorButtonBinding[0];
        List readBindingsList = new ArrayList();
        SensorReadListener[] readBindings = new SensorReadListener[0];

        SensorBinding(Sensor sensor) {
            this.sensor = sensor;
            this.buttons = new int[sensor.getSensorButtonCount()];
            this.read = new Transform3D();
        }

        void updateArrays() {
            this.buttonBindings = this.buttonBindingsList.toArray(new SensorButtonBinding[this.buttonBindingsList.size()]);
            this.readBindings = this.readBindingsList.toArray(new SensorReadListener[this.readBindingsList.size()]);
        }

        public String toString() {
            int n2;
            String string = new String();
            string = "sensor " + this.sensor + "\nbutton listener arrays:\n";
            for (n2 = 0; n2 < this.buttonBindingsList.size(); ++n2) {
                string = string + (SensorButtonBinding)this.buttonBindingsList.get(n2);
            }
            string = string + "read listeners:\n";
            for (n2 = 0; n2 < this.readBindingsList.size(); ++n2) {
                string = string + "  " + (SensorReadListener)this.readBindingsList.get(n2) + "\n";
            }
            return string;
        }
    }

    private static class SensorButtonBinding {
        int buttonsHandled = 0;
        boolean[] prevButtons = null;
        boolean multiButton = false;
        SensorButtonListener[] listeners = null;

        SensorButtonBinding(SensorButtonListener[] sensorButtonListenerArray, boolean bl) {
            this.prevButtons = new boolean[sensorButtonListenerArray.length];
            this.listeners = new SensorButtonListener[sensorButtonListenerArray.length];
            for (int i2 = 0; i2 < sensorButtonListenerArray.length; ++i2) {
                this.prevButtons[i2] = false;
                this.listeners[i2] = sensorButtonListenerArray[i2];
            }
            this.multiButton = bl;
        }

        public String toString() {
            String string = new String();
            string = "  length " + this.listeners.length + ", mutual exclusion " + !this.multiButton + "\n";
            for (int i2 = 0; i2 < this.listeners.length; ++i2) {
                string = string + "    " + (this.listeners[i2] == null ? "null" : this.listeners[i2].toString()) + "\n";
            }
            return string;
        }
    }
}

